package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import com.agilex.healthcare.veteranappointment.datalayer.PersistenceObject;
import com.agilex.healthcare.veteranappointment.datalayer.Transformable;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequestInProcess;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "APPT_REQ_INPROCESS")
public class AppointmentRequestInProcessPo extends PersistenceObject implements Transformable<VARAppointmentRequestInProcess> {

	private static final long serialVersionUID = 8268305988136237418L;
	
	private String appointmentRequestId;
	private String userId;
	private String firstName;
	private String lastName;
	
	public AppointmentRequestInProcessPo(){
		
	}

	public AppointmentRequestInProcessPo(VARAppointmentRequestInProcess dto) {
		this.appointmentRequestId = dto.getAppointmentRequestId();
		this.userId = dto.getUserId();
		this.firstName = dto.getFirstName();
		this.lastName = dto.getLastName();
	}

	@Id
    @Column(name="APPT_REQ_ID", nullable=false)
	public String getAppointmentRequestId() {
		return appointmentRequestId;
	}

    @Column(name="USER_ID", nullable=false)
	public String getUserId() {
		return userId;
	}


	public void setUserId(String userId) {
		this.userId = userId;
	}

    @Column(name="FIRST_NAME", nullable=false)
	public String getFirstName() {
		return firstName;
	}


	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

    @Column(name="LAST_NAME", nullable=false)
	public String getLastName() {
		return lastName;
	}


	public void setLastName(String lastName) {
		this.lastName = lastName;
	}


	@Override
	public VARAppointmentRequestInProcess create() {
        VARAppointmentRequestInProcess dto = new VARAppointmentRequestInProcess();
		dto.setAppointmentRequestId(appointmentRequestId);
		dto.setUserId(userId);
		dto.setFirstName(firstName);
		dto.setLastName(lastName);
		
		return dto;
	}

	public void setAppointmentRequestId(String appointmentRequestId) {
		this.appointmentRequestId = appointmentRequestId;
	}
}
